/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.plant.grape;

import dev.xkmc.youkaishomecoming.content.block.plant.grape.BaseCropVineBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.CenterCropVineBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.VineFruitBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.VineTrunkBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class BranchCropVineBlock
extends BaseCropVineBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty EXTENDED = BooleanProperty.m_61465_((String)"extended");

    public BranchCropVineBlock(BlockBehaviour.Properties prop) {
        super(prop.m_60977_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(false)));
    }

    protected abstract CenterCropVineBlock getCenter();

    @Nullable
    protected abstract VineFruitBlock getHanging();

    protected abstract int getFruitChance();

    @Override
    protected VineTrunkBlock getTrunk() {
        return this.getCenter().getTrunk();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, EXTENDED});
    }

    @Override
    protected void pickup(BlockState state, Level level, BlockPos pos, Player player) {
        super.pickup(state, level, pos, player);
        VineFruitBlock hanging = this.getHanging();
        if (hanging == null) {
            return;
        }
        BlockPos down = pos.m_7495_();
        BlockState hang = level.m_8055_(down);
        if (hang.m_60713_((Block)hanging) && ((Integer)hang.m_61143_((Property)hanging.getAgeProperty())).intValue() == hanging.getMaxAge()) {
            hanging.pickup(hang, level, down, player);
        }
    }

    @Override
    @Nullable
    protected BlockPos getTrunk(BlockState state, BlockGetter level, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockPos next = pos.m_121945_(dir);
        BlockState center = level.m_8055_(next);
        if (!center.m_60713_((Block)this.getCenter())) {
            return null;
        }
        Direction.Axis axis = (Direction.Axis)center.m_61143_(CenterCropVineBlock.AXIS);
        if (dir.m_122434_() != axis) {
            return null;
        }
        return this.getCenter().getTrunk(center, level, next);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState fstate, LevelAccessor level, BlockPos cpos, BlockPos fpos) {
        if (facing.m_122424_() == state.m_61143_((Property)FACING)) {
            state = (BlockState)state.m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(false));
            if (fstate.m_60734_() instanceof BranchCropVineBlock && fstate.m_61143_((Property)FACING) == facing) {
                state = (BlockState)state.m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(true));
            }
        } else if (facing == Direction.DOWN) {
            state = (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf((fstate.m_60713_((Block)this) || fstate.m_60734_() == this.getHanging()) && ((Direction)fstate.m_61143_((Property)FACING)).m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_()));
        }
        return super.m_7417_(state, facing, fstate, level, cpos, fpos);
    }

    @Override
    protected void doGrowth(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.doGrowth(state, level, pos, random);
        int age = (Integer)state.m_61143_((Property)this.getAgeProperty());
        VineFruitBlock hanging = this.getHanging();
        if (hanging == null) {
            return;
        }
        BlockState fruit = level.m_8055_(pos.m_7495_());
        if (fruit.m_60713_((Block)hanging)) {
            int fruitAge = (Integer)fruit.m_61143_((Property)hanging.getAgeProperty());
            if (fruitAge == hanging.getMaxAge()) {
                return;
            }
            if (fruitAge == age || fruitAge < hanging.getBaseAge() && random.m_188503_(this.getFruitChance()) == 0) {
                level.m_7731_(pos.m_7495_(), (BlockState)fruit.m_61124_((Property)hanging.getAgeProperty(), (Comparable)Integer.valueOf(fruitAge + 1)), 2);
            }
        } else if (age == this.getMaxAge() - 1 && fruit.m_60795_() && random.m_188503_(this.getFruitChance()) == 0) {
            level.m_7731_(pos.m_7495_(), (BlockState)hanging.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 2);
        }
    }
}

